/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.registry.chunk.data;

import dev.quantumfusion.dashloader.DashLoader;
import dev.quantumfusion.dashloader.Dashable;
import dev.quantumfusion.dashloader.registry.RegistryReader;
import dev.quantumfusion.dashloader.registry.chunk.data.AbstractDataChunk;
import dev.quantumfusion.dashloader.thread.IndexedArrayMapTask;
import dev.quantumfusion.dashloader.thread.ThreadHandler;

public class StagedDataChunk<R, D extends Dashable<R>>
extends AbstractDataChunk<R, D> {
    public final IndexedArrayMapTask.IndexedArrayEntry<D>[][] dashables;
    public final int dashablesSize;

    public StagedDataChunk(byte pos, String name, IndexedArrayMapTask.IndexedArrayEntry<D>[][] dashables, int dashablesSize) {
        super(pos, name);
        this.dashables = dashables;
        this.dashablesSize = dashablesSize;
    }

    @Override
    public void preExport(RegistryReader reader) {
        IndexedArrayMapTask.IndexedArrayEntry<D>[][] indexedArrayEntryArray = this.dashables;
        int n = indexedArrayEntryArray.length;
        for (int i = 0; i < n; ++i) {
            IndexedArrayMapTask.IndexedArrayEntry<D>[] stage;
            for (IndexedArrayMapTask.IndexedArrayEntry<D> entry : stage = indexedArrayEntryArray[i]) {
                ((Dashable)entry.object()).preExport(reader);
            }
        }
    }

    @Override
    public void export(Object[] data, RegistryReader registry) {
        ThreadHandler threadHandler = DashLoader.DL.thread;
        for (IndexedArrayMapTask.IndexedArrayEntry<D>[] dashable : this.dashables) {
            threadHandler.parallelExport(dashable, data, registry);
        }
    }

    @Override
    public void postExport(RegistryReader reader) {
        IndexedArrayMapTask.IndexedArrayEntry<D>[][] indexedArrayEntryArray = this.dashables;
        int n = indexedArrayEntryArray.length;
        for (int i = 0; i < n; ++i) {
            IndexedArrayMapTask.IndexedArrayEntry<D>[] stage;
            for (IndexedArrayMapTask.IndexedArrayEntry<D> entry : stage = indexedArrayEntryArray[i]) {
                ((Dashable)entry.object()).postExport(reader);
            }
        }
    }

    @Override
    public int getDashableSize() {
        return this.dashablesSize;
    }
}

